package com.jonohennessy {
	import flash.display.*;
	import flash.text.*;
	import flash.net.*;
	import flash.events.*;
	
	public class ElementIcon extends Sprite {
		private var xml:XML;
		private var background:Sprite;
		private var imageHolder:Sprite;
		private var imageLoader:Loader;
		private var iconLabel:TextField;
		
		public function ElementIcon(xml:XML) {
			this.xml = xml;
			
			// Draw a bg at the back
			background = new Sprite();
			background.graphics.beginFill(0xFFFFFF, 1);
			background.graphics.lineStyle();
			background.graphics.drawRect(0, 0, 265, 110);
			addChild(background);
			
			// Holder for image
			imageHolder = new Sprite();
			
			// Load image
			var imageRequest:URLRequest = new URLRequest("glasses/"+xml.@browserImage);
			imageLoader = new Loader();
			imageLoader.contentLoaderInfo.addEventListener(Event.INIT, displayImage);
			imageLoader.load(imageRequest);
			addChild(imageHolder);
			
			// Build text
			iconLabel = new TextField();
			var iconFormat:TextFormat = new TextFormat();
			iconFormat.font = "Helvetica";
			iconFormat.color = 0x000000;
			iconFormat.size = 12;
			iconLabel.defaultTextFormat = iconFormat;
			iconLabel.text = xml.@model;
			iconLabel.y = 100;
			iconLabel.selectable = false;
			addChild(iconLabel);
		}
		
		private function displayImage(e:Event):void {
			imageHolder.addChild(imageLoader.content);
		}
		
		public function getXML():XML {
			return xml[0];
		}
	}
}